;coded by UEZ build 2015-07-27
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so ;/pe ;/rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <Array.au3>
#include <GDIPlus.au3>
#include <WindowsConstants.au3>

Opt("MustDeclareVars", 1)
Opt("GUIOnEventMode", 1)

Global Const $iWidth = 1000
Global Const $iHeight = 500

Global $hGUI = GUICreate("GDI+ Rotating Text", $iWidth, $iHeight)

If @OSBuild < 6000 Then WinSetTrans($hGUI, "", 0xFF) ;workaround for XP machines when alpha blending is activated on _GDIPlus_GraphicsClear() function to avoid slow drawing

_GDIPlus_Startup()
Global Const $hDC = _WinAPI_GetDC($hGUI)
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iWidth, $iHeight)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hGraphic = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)

_GDIPlus_GraphicsSetSmoothingMode($hGraphic, 4)
_GDIPlus_GraphicsSetPixelOffsetMode($hGraphic, 4)
_GDIPlus_GraphicsSetTextRenderingHint($hGraphic, 4)

Global Const $hPen = _GDIPlus_PenCreate(0xF00D121A, 8)
_GDIPlus_PenSetLineJoin($hPen, 2)

Global Const $hBrush = _GDIPlus_BrushCreateSolid(0xFF000000 + 0xFFD700)

Global Const $iFontSize = 190, $sText = "Loading"
Global Const $hFamily = _GDIPlus_FontFamilyCreate("Times New Roman")
Global Const $hFormat = _GDIPlus_StringFormatCreate()
Global Const $hFont = _GDIPlus_FontCreate($hFamily, $iFontSize, 0)
Global $tLayout = _GDIPlus_RectFCreate(0, 0, $iWidth, $iHeight)

_GDIPlus_StringFormatSetAlign($hFormat, 1)
_GDIPlus_StringFormatSetLineAlign($hFormat, 1)

Global Const $hPath = _GDIPlus_PathCreate()
_GDIPlus_PathAddString($hPath, $sText, $tLayout, $hFamily, 0, $iFontSize, $hFormat)
_GDIPlus_PathFlatten($hPath)

Global Const $fPi = ACos(-1), $fRad2Deg = 180 / $fPi, $iAmountCorners = 4, $iPerspCorrection = 2200, $fSize = 550
Global $fRotSpeed, $start_x, $start_y
Global $aCoordinates[$iAmountCorners][3] = 	[ _;	X			Y			Z
												[	-$fSize, 	-$fSize, 		0], _ ;2
												[ 	$fSize, 	-$fSize, 		0], _ ;3
												[	-$fSize, 	$fSize, 		0], _ ;0
												[ 	$fSize, 	$fSize, 		0]] _ ;1

;	0		1
;
;
;	2		3


$start_x = $iWidth / 2
$start_y = $iHeight / 2
GUISetState()

GUISetOnEvent(-3, "Close")

;~ Draw_Chars(0, 1, 2, 3)

Do
	Draw_Chars(0, 1, 2, 3)
Until Not Sleep(10)

Func Draw_Chars($p1, $p2, $p3, $p4)
#Region calculate positionn
	Local $x1, $y1, $x2, $y2, $x3, $y3, $x4, $y4, $z1, $z2, $z3
	$x1 = $aCoordinates[$p1][0] * (1 + $aCoordinates[$p1][2] / $iPerspCorrection)
	$y1 = $aCoordinates[$p1][1] * (1 + $aCoordinates[$p1][2] / $iPerspCorrection)
	$z1 = $aCoordinates[$p1][2]
	$x2 = $aCoordinates[$p2][0] * (1 + $aCoordinates[$p2][2] / $iPerspCorrection)
	$y2 = $aCoordinates[$p2][1] * (1 + $aCoordinates[$p2][2] / $iPerspCorrection)
	$z2 = $aCoordinates[$p2][2]
	$x3 = $aCoordinates[$p3][0] * (1 + $aCoordinates[$p3][2] / $iPerspCorrection)
	$y3 = $aCoordinates[$p3][1] * (1 + $aCoordinates[$p3][2] / $iPerspCorrection)
	$z3 = $aCoordinates[$p3][2]
	$x4 = $aCoordinates[$p4][0] * (1 + $aCoordinates[$p4][2] / $iPerspCorrection)
	$y4 = $aCoordinates[$p4][1] * (1 + $aCoordinates[$p4][2] / $iPerspCorrection)

	Local $aPoints[5][2], $v1, $v2, $v3, $fDeg, $r, $g, $b
	$aPoints[0][0] = 4
	$aPoints[1][0] = $start_x + $x1
	$aPoints[1][1] = $start_y + $y1
	$aPoints[2][0] = $start_x + $x2
	$aPoints[2][1] = $start_y + $y2
	$aPoints[3][0] = $start_x + $x3
	$aPoints[3][1] = $start_y + $y3
	$aPoints[4][0] = $start_x + $x4
	$aPoints[4][1] = $start_y + $y4
#EndRegion

	$v1 = ($y1 - $y2) * ($z3 - $z2) - ($z1 - $z2) * ($y3 - $y2)
	$v2 = ($z1 - $z2) * ($x3 - $x2) - ($x1 - $x2) * ($z3 - $z2)
	$v3 = ($x1 - $x2) * ($y3 - $y2) - ($y1 - $y2) * ($x3 - $x2)
	$fDeg = Ceiling(ASin(Sqrt(($v2 * $v2 + $v1 * $v1) / ($v1 * $v1 + $v2 * $v2 + $v3 * $v3))) * $fRad2Deg)
;~ 	0xFFF345
	$r = 0xFF - $fDeg < 0 ? 0 : 0xFF - $fDeg
	$g = 0xD7 - $fDeg < 0 ? 0 : 0xD7 - $fDeg
	$b = 0x00 - $fDeg < 0 ? 0 : 0x00 - $fDeg
	_GDIPlus_BrushSetSolidColor($hBrush, 0xFF000000 + $r * 0x10000 + $g * 0x100 + $b)

	_GDIPlus_GraphicsClear($hGraphic, 0x80FFFFFF)
	Local $hPath_Clone = _GDIPlus_PathClone($hPath)
	_GDIPlus_PathWarp($hPath_Clone, Null, $aPoints, 0, 0, $iWidth, $iHeight)
	_GDIPlus_GraphicsDrawPath($hGraphic, $hPath_Clone, $hPen)
	_GDIPlus_GraphicsFillPath($hGraphic, $hPath_Clone, $hBrush)
	_GDIPlus_PathDispose($hPath_Clone)
	_WinAPI_BitBlt($hDC, 0, 0, $iWidth, $iHeight, $hDC_backbuffer, 0, 0, $SRCCOPY)

#Region rotate points
	Local $i, $x, $y
	Local Static $f = 0
	$fRotSpeed = -0.0333 * Cos($f / 350)
	$f += 10
	For $i = 0 To $iAmountCorners - 1 ;calculate y-axis rotation only
;~ 		Calc(0, $fRotSpeed, $i)
		$x = $aCoordinates[$i][0] * Cos($fRotSpeed) + $aCoordinates[$i][2] * Sin($fRotSpeed)
		$y = -$aCoordinates[$i][0] * Sin($fRotSpeed) + $aCoordinates[$i][2] * Cos($fRotSpeed)
		$aCoordinates[$i][0] = $x
		$aCoordinates[$i][2] = $y
	Next
#EndRegion
EndFunc   ;==>Draw_Chars

;~ Func Calc($angle_x, $angle_y, $i)	;calculate 3D rotation
;~ 	Local Const $x = $aCoordinates[$i][0] * Cos($angle_y) + $aCoordinates[$i][2] * Sin($angle_y)
;~ 	Local Const $y = $aCoordinates[$i][1]
;~ 	Local Const $z = -$aCoordinates[$i][0] * Sin($angle_y) + $aCoordinates[$i][2] * Cos($angle_y)
;~ 	$aCoordinates[$i][0] = $x
;~ 	$aCoordinates[$i][1] = $y * Cos($angle_x) - $z * Sin($angle_x)
;~ 	$aCoordinates[$i][2] = $y * Sin($angle_x) + $z * Cos($angle_x)
;~ EndFunc   ;==>Calc

Func Close()
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_PathDispose($hPath)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_GraphicsDispose($hGraphic)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_DeleteObject($hBrush)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc   ;==>Close
